#include <math.h>
#include <allegro.h>

SAMPLE *sfx_fire, *sfx_hit, *sfx_damage, *sfx_refuel;

void sfx_create(void)
{
	static int first = 0;
	int n;
	
	if (first) return;
	first = 1;

	sfx_fire = create_sample(8, 0, 44100, 1024);
	sfx_hit = create_sample(8, 0, 44100, 1024);
	sfx_damage = create_sample(8, 0, 44100, 1024);
	sfx_refuel = create_sample(8, 0, 44100, 128);
	for (n = 0; n < 1024; n++) {
		float t = n / 44100.0;
		float f = sin(n / 512.0 * 3.1415);

		*((char *) sfx_damage->data + n) = 128 + 127 * f *
			sin(2000 * t + sin(600 * t * t) * 5);

		*((char *) sfx_hit->data + n) = 128 + 127 * f *
			sin(cos(3.1415 * 2 * 1000 * (1 - f) * t));

		*((char *) sfx_fire->data + n) = 128 + 127 * f *
			cos(3.1415 * 2 * (2000 - n / 2) * t);

	}
	for (n = 0; n < 128; n++) {
		float t = n * 8 / 44100.0;
		float f = sin(n * 8 / 512.0 * 3.1415);
		*((char *) sfx_refuel->data + n) = 128 + 127 * f *
			sin(300 * t + sin(600 * t * t) * 5);
	}
}
